//=============================================================================
// UTJMHBase ver 2.9
//  Copyright 2004 zeal
//=============================================================================
class XmasUTJMHBase expands mutator config;
// config(UTJMH);

// imiarunoka humei(lo
// #exec OBJ LOAD FILE=..\Sounds\Male1Voice.uax PACKAGE=(ALL)
// #exec OBJ LOAD FILE=..\Sounds\Male2Voice.uax PACKAGE=(ALL)
// #exec OBJ LOAD FILE=..\Sounds\FeMale1Voice.uax PACKAGE=(ALL)
// #exec OBJ LOAD FILE=..\Sounds\FeMale2Voice.uax PACKAGE=(ALL)
// imi nai mitai(lo

var bool Initialized;
var int AmpCount;
var int kakuCount;
var int HealthCount;

// conf
var config bool bEnable;
var config int AmpTime;
var config int kakuTime;
var config int HealthTime;
var config bool bUseRandomWeapon;
var config int HealthRegenPerSec;
var config int HealthRegenPerSecMin;
var config int MaxHealth;
var config bool bUseRegenAmmo;
var config bool bUseRegenHealth;
var config bool bGiveArmor;
var config bool bUseWarnTeamDamage;
var config int MaxRegenHealth;
var config int HealthRegenPerKill;
var config int HealthRegenPerKillMin;
var config bool bUseUTJTimer;
var config bool bUseMonsterHUD;
var config int DefaultHealth;
var config bool bUseAntiBoost;

var string version;
//var String servername;
//var string Decoration;

var String UTJNaliFruit;
var String UTJMedBox;
var String UTJHealthPack;
var String UTJUnrealHealth;
var String UTJHealthVial;


function PostBeginPlay()
{
	if (Initialized)
		return;

	if(CheckConfig())
	{// err
		return;
	}
	Log(" ");
	Log("--- UTJ MonsterHunt Mutator v29 Xmas edition initialized ");
	Log(" ");


	Initialized = True;

	kakuCount = 0;
	HealthCount = 0;

	if(DefaultHealth < 1)
		DefaultHealth = 100;

	if(bUseUTJTimer)
		SetTimer(1, True);
	if(bUseMonsterHUD)
		Level.Game.HUDType = class'UTJMH29.UTJ_HUD';
	Level.Game.RegisterDamageMutator(Self);

	TournamentGameInfo(Level.Game).GameName = Level.Game.Default.GameName@"with UTJMH Xmas Edition";

	// fix mover
	fixmover();

	if ( NextMutator != None )
		NextMutator.PostBeginPlay();

}

function fixmover()
{
// light fix
	local mover M;
	foreach AllActors( class 'Mover', M)
	{
		if(M.bTriggerOnceOnly && M.MoverEncroachType == ME_ReturnWhenEncroach)
		{
			log("Hit!! bTriggerOnceOnly & ME_ReturnWhenEncroach @"@M.name);
			M.MoverEncroachType = ME_IgnoreWhenEncroach;
		}
	}
}





function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{

	if(Other.IsA('NaliFruit') && !Other.IsA('UTJNaliFruit'))
	{
//			ReplaceWith(Other,UTJNaliFruit);
				return true;
	}
	if(Other.IsA('MedBox') && !Other.IsA('UTJMedBox'))
	{
//			ReplaceWith(Other,UTJMedBox);
			return true;
	}
	if(Other.IsA('SuperHealth') || Other.IsA('HealthPack') && !Other.IsA('UTJHealthPack') && !Other.IsA('BHealthPack') && !Other.IsA('UTJUnrealHealth'))
	{
//			ReplaceWith(Other,UTJHealthPack);
			return true;
	}
	if(Other.IsA('Health') && !Other.IsA('UTJHealthPack') && !Other.IsA('UTJUnrealHealth') && !Other.IsA('SuperHealth') && !Other.IsA('UTJNaliFruit'))
	{
//			ReplaceWith(Other,UTJUnrealHealth);
			return true;
	}
	if(Other.IsA('HealthVial') && !Other.IsA('UTJHealthVial'))
	{
//			ReplaceWith(Other,UTJHealthVial);
				return true;
	}

	if(Other.IsA('TournamentHealth') && !Other.IsA('BP_Health') && !Other.IsA('MedBox') && !Other.IsA('HealthPack') && !Other.IsA('HealthVial') && !Other.IsA('UTJHealthPack') && !Other.IsA('UTJHealthVial') && !Other.IsA('UTJMedBox'))
	{
//			ReplaceWith(Other,"BPSE.BP_Health"); // BPSE taiou.
				return true;
	}

  bSuperRelevant = 0;
  return true;
}





function GiveAmp(Pawn PlayerPawn)
{

	local UDamage damage;

	if( (PlayerPawn.FindInventoryType(class'UDamage') != None) ||
		(PlayerPawn.Health <= 0) )
		return;

	damage = spawn(class'xmasUDamage',PlayerPawn,,PlayerPawn.Location);

	if( damage != None )
	{
		damage.RespawnTime = 0.0;
		damage.GiveTo(PlayerPawn);
		damage.Activate();
	}

}


function MutatorTakeDamage (
	out int ActualDamage,
	Pawn Victim,
	Pawn InstigatedBy,
	out Vector HitLocation,
	out Vector Momentum,
	name DamageType)
{
	local Pawn P;

	if(DamageType == 'Impact') // hammer x5 ii !
	{
	   ActualDamage *= 5;
	}

	if(bUseAntiBoost)
	{
		if(Victim != None && InstigatedBy != None)
		{
		     if(Victim.IsA('TournamentPlayer') && InstigatedBy.IsA('TournamentPlayer'))
			Momentum.z *= 0.1;
			Momentum.x *= 0.1;
			Momentum.y *= 0.1;
		}
	}

	if(ActualDamage > 0 && Victim != None && InstigatedBy != None)
	{
//Log("Dam:"@ActualDamage@"victim "@Victim.name@"instigatedby"@InstigatedBy.name@" dam type:"@DamageType);
		if(Victim.IsA('PlayerPawn') && InstigatedBy.IsA('PlayerPawn') && Victim != InstigatedBy && bUseWarnTeamDamage)
		{// InstigatedBy > killer  Victim > killed
		  //danger
			if ( InstigatedBy.IsA('TournamentPlayer') )
				InstigatedBy.ReceiveLocalizedMessage( class'UTJMH29.UTJTKMessage',Victim.Health - ActualDamage, Victim.PlayerReplicationInfo );

		        //BroadCastMessage("Dam: victim"@ActualDamage@Victim.PlayerReplicationInfo.PlayerName@"instigatedby"@InstigatedBy.PlayerReplicationInfo.PlayerName@DamageType);
			if(Victim.Health - ActualDamage<= 0 && Victim != InstigatedBy)
			{
			   Log("TK? :(dam:"@ActualDamage@")killed"@Victim.PlayerReplicationInfo.PlayerName@"killer"@InstigatedBy.PlayerReplicationInfo.PlayerName@"type:"@DamageType);
				if ( Victim.IsA('TournamentPlayer') )
				{
				for ( P=Level.PawnList; P!=None; P=P.NextPawn )
					if ( P.IsA('TournamentPlayer') )
					P.ReceiveLocalizedMessage( class'UTJTKMessage',9999, InstigatedBy.PlayerReplicationInfo );
				}
			if ( InstigatedBy.IsA('TournamentPlayer') )
				InstigatedBy.ReceiveLocalizedMessage( class'UTJMH29.UTJTKMessage',Victim.Health - ActualDamage, Victim.PlayerReplicationInfo );
			}
		}
		if(Victim.IsA('ScriptedPawn') && InstigatedBy.IsA('ScriptedPawn'))
		    ActualDamage = 0;
		if(Victim == InstigatedBy && Victim.IsA('ScriptedPawn')) // zibaku
		    ActualDamage = 0;
	}
	//spawn(class'WarExplosion',,,HitLocation); afo
	if ( NextDamageMutator != None )
		NextDamageMutator.MutatorTakeDamage(ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);

}
function ModifyPlayer(Pawn Other)
{
	local int randm;
	local inventory inv;


	if(!Other.IsA('TournamentPlayer'))return;
	 TournamentPlayer(Other).PlayerReplicationInfo.Team = 0; // kyouseitekini team 0


	Other.Health = DefaultHealth;

	// random weapon
	// ges,shock,pulse,ripper,mini,flak,rocket,sniper
	if (bUseRandomWeapon && Other.IsA('TournamentPlayer') ) // players only
	{
		randm = Rand(10);
		switch(randm)
		{
			case 0:
				GiveWeapon(Other,class'UT_Biorifle');
				Other.Health += 100;
			break;
			case 1:
				GiveWeapon(Other,class'Shockrifle');
				Other.Health += 50;
			break;
			case 2:
				GiveWeapon(Other,class'Pulsegun');
				Other.Health += 80;
			break;
			case 3:
				GiveWeapon(Other,class'ripper');
				Other.Health += 110;
			break;
			case 4:
				GiveWeapon(Other,class'minigun2');
				Other.Health += 90;
			break;
			case 5:
				GiveWeapon(Other,class'UT_Flakcannon');
				Other.Health += 30;
			break;
			case 6:
				GiveWeapon(Other,class'UT_EightBall');
				Other.Health += 20;
			break;
			case 7:
				GiveWeapon(Other,class'SniperRifle');
				Other.Health += 20;
			break;
			case 8:
				//GiveWeapon(Other,class'');
				Other.Health += 1000;
			break;
			case 9:
				GiveWeapon(Other,class'ImpactHammer');
				Other.Health += 400;
			break;
		}
		if(bGiveArmor)
		{
			inv = Spawn(class'Armor2');
			if( inv != None )
			{
				inv.bHeldItem = true;
				inv.RespawnTime = 0.0;
				inv.GiveTo(Other);
				inv.Charge = Inv.Default.Charge;
			}
		}
		Other.ReceiveLocalizedMessage( class'UTJMH29.UTJGetWeaponMessage', randm, Other.PlayerReplicationInfo, Other.PlayerReplicationInfo );
	}

	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}

function GiveWeapon(Pawn PlayerPawn, class<TournamentWeapon> WeaponClass )
{
	local Weapon NewWeapon;

	if( PlayerPawn.FindInventoryType(WeaponClass) != None )
		return;
	newWeapon = Spawn(WeaponClass);
	if( newWeapon != None )
	{
		newWeapon.RespawnTime = 0.0;
		newWeapon.GiveTo(PlayerPawn);
		newWeapon.bHeldItem = true;
		newWeapon.SetSwitchPriority(PlayerPawn);
		newWeapon.WeaponSet(PlayerPawn);
		newWeapon.AmbientGlow = 0;
		//if ( PlayerPawn.IsA('PlayerPawn') )
		//	newWeapon.SetHand(PlayerPawn(PlayerPawn).Handedness);
		//else
		//	newWeapon.GotoState('Idle');
		//PlayerPawn.Weapon.GotoState('DownWeapon');
		PlayerPawn.PendingWeapon = None;
		//PlayerPawn.Weapon = newWeapon;
		if ( !newWeapon.IsA('ImpactHammer') && !newWeapon.IsA('Translocator') ) {
			newWeapon.GiveAmmo(PlayerPawn);
			newWeapon.AmmoType.AmmoAmount = newWeapon.AmmoType.MaxAmmo/10;
		}
	}
}


function ScoreKill(Pawn Killer, Pawn Other)
{

//	BroadcastMessage("Killer"@Killer@" Other"@ Other);

	if(Killer == None)return; // sui
	if(!Killer.bIsHuman)return; // bot iran
	if(Killer.PlayerReplicationInfo.bIsABot) return; // bot irane-
	if(Killer.IsA('ScreptedPawn'))return;
	if(Killer.IsA('ScreptedPawn') && Other.IsA('ScreptedPawn'))return;
	if ( (Killer == None) && (Other == None) )return; // ?
	//BroadcastMessage("Killer"@Killer@" Other"@ Other);

	if ( Killer.bIsPlayer && Other.bIsPlayer )return; // tk

	if ( Other.Spree > 1 && Other.bIsPlayer)
		EndSpree(Killer, Other);
	if(Other.bIsPlayer)Other.Spree = 0;

		if ( (Killer != None) && Killer.bIsPlayer && (Killer != Other) )
		{
			if(Killer.Health <= MaxHealth)Killer.Health += Rand(HealthRegenPerKill)+HealthRegenPerKillMin;
			Killer.Spree+=1;
			if ( Killer.Spree > 14 )
				NotifySpree(Killer, Killer.Spree);

			if ( (TournamentPlayer(Killer).Level.TimeSeconds - TournamentPlayer(Killer).LastKillTime < 3))
			{
				TournamentPlayer(Killer).MultiLevel++;
				if(TournamentPlayer(Killer).MultiLevel >= 41)TournamentPlayer(Killer).MultiLevel = 40;
				TournamentPlayer(Killer).ReceiveLocalizedMessage( class'UTJMH29.UTJMultiKillMessage', TournamentPlayer(Killer).MultiLevel );
				CheckBroadCast(Killer,TournamentPlayer(Killer).MultiLevel);
			}
			else
				TournamentPlayer(Killer).MultiLevel = 0;

			TournamentPlayer(Killer).LastKillTime = TournamentPlayer(Killer).Level.TimeSeconds;
		}


	//Super.ScoreKill(Killer, Other);
}

function CheckBroadCast(Pawn Killer,int num)
{
	if(Killer.bIsPlayer && !Killer.PlayerReplicationInfo.bIsABot)
	BroadCastMessage(Killer.PlayerReplicationInfo.PlayerName@GetText(num));
}

function string GetText(int Switch)
{
	switch (Switch)
	{
		case 1:
			return " has Double Kill!";
			break;
		case 2:
			return " has Multi Kill!";
			break;
		case 3:
			return " has Mega Kill!";
			break;
		case 4:
			return " has ULTRA KILL!";
			break;
		case 5:
			return " has MONSTER KILL!";
			break;
		case 6:
			return " has LUDICROUS KILL!";
			break;
		case 7:
		case 8:
		case 9:
		case 10:
		case 11:
		case 12:
		case 13:
		case 14:
		case 15:
		case 16:
		case 17:
		case 18:
		case 19:
		case 20:
		case 21:
		case 22:
		case 23:
		case 24:
		case 25:
		case 26:
		case 27:
		case 28:
		case 29:
		case 30:
		case 31:
		case 32:
		case 33:
		case 34:
		case 35:
		case 36:
		case 37:
		case 38:
		case 39:
			return " has HOLY SHIT!";
			break;
		case 40:
		case 41:
			return " is S A N T A   C L A U S !!!!!!";
			break;
	}
	return "";
}
function NotifySpree(Pawn Other, int num)
{
	local Pawn P;

	if ( num == 15 )
		num = 0;
	else if ( num == 35 )
		num = 1;
	else if ( num == 60 )
		num = 2;
	else if ( num == 90 )
		num = 3;
	else if ( num == 125 )
		num = 4;
	else if ( num == 250 )
		num = 5;
	else
		return;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.IsA('TournamentPlayer') )
			P.ReceiveLocalizedMessage( class'UTJMH29.UTJKillingSpreeMessage', Num, Other.PlayerReplicationInfo );
}


function EndSpree(Pawn Killer, Pawn Other)
{
	local Pawn P;
// koko kurunoka wakaran(lo
//	BroadcastMessage("Endspree Killer"@Killer@" Other"@ Other);
	if ( !Other.bIsPlayer || Killer.PlayerReplicationInfo.bIsABot)
		return;
	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
	if ( P.IsA('TournamentPlayer') )
	{
		if(Other.IsA('ScriptedPawn'))
			P.ReceiveLocalizedMessage( class'UTJMH29.UTJKillingSpreeMessage', Other.Spree, Killer.PlayerReplicationInfo,  Killer.PlayerReplicationInfo );
		else // pk end
			P.ReceiveLocalizedMessage( class'UTJMH29.UTJKillingSpreeMessage', Other.Spree, Killer.PlayerReplicationInfo, Other.PlayerReplicationInfo );

	}
}

function Timer()
{

	// regenerate ammo (except redeemer) & health in one fell swoop
	local Pawn P;
	local Inventory Inv;

	if (AmpCount < AmpTime)AmpCount++;

	else if (AmpCount == AmpTime) {

		BroadcastLocalizedMessage( class'UTJMH29.UTJMHAmpMessage',,, None, None );

		// give all current players damage amps
		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			if ( P.IsA('Bot')  || P.IsA('TournamentPlayer'))
				GiveAmp(P);

		AmpCount = 0;
	}

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.IsA('Bot')  || P.IsA('TournamentPlayer')) {

			if (P.Health > 0) {

				// ammo
				if(bUseRegenAmmo)
				{
				for( Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory )
					if ( (Ammo(Inv)!=None) && (P.bFire==0) && (P.bAltFire==0) )
						if (Ammo(Inv).AmmoAmount < Ammo(Inv).MaxAmmo * 10) {
							Ammo(Inv).AmmoAmount += Ammo(Inv).Default.AmmoAmount/3;
							if (Ammo(Inv).AmmoAmount > Ammo(Inv).MaxAmmo * 10)
								Ammo(Inv).AmmoAmount = Ammo(Inv).MaxAmmo * 10;
						}
				}

				if(bUseRegenHealth)
				{
				// health
				if ( P.Health < MaxRegenHealth && !P.Region.Zone.bWaterZone)
					P.Health = FMin(MaxRegenHealth, P.Health + Rand(HealthRegenPerSec)+HealthRegenPerSecMin);
				}

			}

		}

 //random redeemer & health

    P = GetRandomPlayer();
    if(P != None)
    {
        if (kakuCount < kakuTime)kakuCount ++;
  	if (HealthCount < HealthTime)HealthCount ++;

        if(kakuTime-kakuCount < 5 &&  kakuTime-kakuCount > 0)
        {
         BroadcastLocalizedMessage(class'UTJMH29.UTJRandomRedeemerMsg',kakuTime-kakuCount,P.PlayerReplicationInfo  );
        }

	if(HealthTime-HealthCount < 5 && HealthTime-HealthCount > 0)
	{
   	 BroadcastLocalizedMessage(class'UTJMH29.UTJRandomHealthMsg',HealthTime-HealthCount,P.PlayerReplicationInfo  );
   	}

      //BroadcastMessage("Count"@kakuCount@" kakuTime"@kakuTime);

        if (kakuCount >= kakuTime)
        {
   	     kakuCount = 0;
             P = GetRandomPlayer();
             if(P.bIsPlayer)
             {
               BroadcastLocalizedMessage(class'UTJMH29.UTJRandomRedeemerMsg',kakuCount,P.PlayerReplicationInfo  );
               GiveRedeemer(P);
             }
        }

        if (HealthCount >= HealthTime)
        {
	     HealthCount = 0;
             P = GetRandomPlayer();
             if(P.bIsPlayer)
             {
               BroadcastLocalizedMessage(class'UTJMH29.UTJRandomHealthMsg',HealthCount,P.PlayerReplicationInfo  );
               GiveHealth(P);
             }
	}

    }

}

function GiveRedeemer(Pawn PlayerPawn)
{

	local Warheadlauncher  rede;
	rede= spawn(class'Warheadlauncher');

	if( rede!= None )
	{
        rede.RespawnTime = 0.0;
        rede.GiveTo(PlayerPawn);
        rede.SetSwitchPriority(PlayerPawn);

//      rede.Instigator = PlayerPawn;
//      rede.BecomeItem();
		PlayerPawn.AddInventory(rede);
//      rede.BringUp();
        rede.PickupAmmoCount = 1;
		rede.GiveAmmo(PlayerPawn);

	}

}

function GiveHealth(Pawn PlayerPawn)
{

	PlayerPawn.Health+=500;
}

function Pawn GetRandomPlayer() {
  local Pawn N;
  local PlayerPawn Dest;
  local Pawn Candidate[32];
  local int num;

  for (N=Level.PawnList; N!=None; N=N.NextPawn) {
    Dest=PlayerPawn(N);
    if (Dest!=None && Dest.bIsPlayer && !Dest.PlayerReplicationInfo.bIsSpectator) {
      if (num<32) Candidate[num] = Dest;
      else if (Rand(num) < 32) Candidate[Rand(32)] = Dest;
      num++;
    }
  }

  if(num==0) return None;
  return Candidate[Rand(Min(32,num))];
}

function bool CheckConfig()
{
	if(!bEnable)return true;
	Log("---  Config  ---");
	Log("---  AmpTime ="@AmpTime);
	Log("---  kakuTime ="@kakuTime);
	Log("---  HealthTime ="@HealthTime);
	if(bUseRandomWeapon)
		Log("---  UseRandomWeapon");
	Log("---  HealthRegenPerSec ="@HealthRegenPerSec);
	Log("---  HealthRegenPerSecMin ="@HealthRegenPerSecMin);
	Log("---  MaxHealth ="@MaxHealth);
	if(bUseRegenAmmo)
		Log("---  UseRegenAmmo");
	if(bUseRegenHealth)
		Log("---  UseRegenHealth");
	if(bGiveArmor)
		Log("---  UseGiveArmor");
	if(bUseWarnTeamDamage)
		Log("---  UseWarnTeamDamage");
	Log("---  MaxRegenHealth ="@MaxRegenHealth);
	Log("---  HealthRegenPerKill ="@HealthRegenPerKill);
	Log("---  HealthRegenPerKillMin ="@HealthRegenPerKillMin);
	if(bUseUTJTimer)
		Log("---  UseUTJTimer(UseRandomRedeemer..etc)");

	if(bUseAntiBoost)
		Log("---  UseAntiBoost");
	else
		Log("---  AntiBoost is Disable");

	return false;
}

